/*
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License version 2 
    as published by the Free Software Foundation.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA


    Copyright (C) 2006  Thierry Berger-Perrin <tbptbp@gmail.com>
*/
#include "specifics.h"

namespace sys {
    namespace mem {
        #if defined WIN32
            void *allocate(const size_t size) { return VirtualAlloc(0, size, MEM_COMMIT, PAGE_READWRITE); }
            void liberate(void * const p) { VirtualFree(p, 0, MEM_RELEASE); }
        #elif defined LINUX
            void *allocate(const size_t size) { return _mm_malloc(size, 4096); }
            void liberate(void * const p) { _mm_free(p); }
        #endif
    }
}
